#include <windows>
#include <setupapi>
#include <iostream>
#include <assert>
#include <string>
#include <sysutils.hpp>
#include "usb_R6_1.h"

using namespace std;
//---------------------------------------------------------
TUSBDevice::TUSBDevice()
{
   memberIndex = 0;
   deviceInterfaceDetailData = NULL;
   hHidLib = NULL;
   hHidLib = LoadLibrary("HID.DLL");
   if (!hHidLib)
     displayError("Bad doaczenia biblioteki HID.DLL.");

   (FARPROC&) HidD_GetHidGuid=GetProcAddress(hHidLib, "HidD_GetHidGuid");
   (FARPROC&) HidD_GetAttributes=GetProcAddress(hHidLib, "HidD_GetAttributes");

   if (!HidD_GetHidGuid || !HidD_GetAttributes){
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono jednej lub wicej funkcji eksportowych.\n");
   }
}
//---------------------------------------------------------
TUSBDevice::~TUSBDevice()
{
  if(hHidLib != NULL)
    FreeLibrary(hHidLib);
}
//---------------------------------------------------------
void TUSBDevice::displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//----------------------------------------------------------
void TUSBDevice::setUshortVid(USHORT vid)
{
  usVid = vid;
}
//----------------------------------------------------------
string TUSBDevice::getUSBDevicePath(UINT)
{
   HidD_GetHidGuid(&classGuid);
   deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                   DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE){
      FreeLibrary(hHidLib);
      displayError("Nie zidentyfikowano podczonych urzdze.\n");
   }

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);

   SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL, &classGuid,
                                     memberIndex, &deviceInterfaceData);
   SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);
   deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];
   deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);

   if (SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
            deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
            NULL, NULL)) {
       pathUSBDevice = deviceInterfaceDetailData->DevicePath;
       //cout << pathUSBDevice << endl;
   }
   releaseMemory(deviceInterfaceDetailData);
   SetupDiDestroyDeviceInfoList(deviceInfoSet);
   return pathUSBDevice;
}
//---------------------------------------------------------
HANDLE TUSBDevice::synchOpenUSBDevice()
{
   string devUSBpath;
   HANDLE  hidDevObject = INVALID_HANDLE_VALUE;
   while((devUSBpath = getUSBDevicePath(memberIndex++)) != "" ){
      hidDevObject = CreateFile(devUSBpath.c_str(), GENERIC_READ | \
                          GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE,
	                  NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL );

      HidD_GetAttributes(hidDevObject, &hiddAttributes);
      printf("VID/PID/wersja = %d/%d/%d\n",hiddAttributes.VendorID,
                                           hiddAttributes.ProductID,
                                           hiddAttributes.VersionNumber);

      if(hiddAttributes.VendorID == usVid){
         return hidDevObject;
         break;
      }
      else
        if(memberIndex > searchMaxDevice)
           displayError("Nie znaleziono urzdzenia o podanycm VID");
   }
   return INVALID_HANDLE_VALUE;
}
//---------------------------------------------------------
bool TUSBDevice::synchReadUSBReport(HANDLE hidDevObject, void *inputReportBuffer,
                                    ULONG inputReportBufferLength)
{
   result = 0;
   numberOfBytesRead = 0;
   OVERLAPPED *overlapped = NULL;
   if(overlapped == NULL){
      overlapped = new OVERLAPPED;
      overlapped->hEvent = CreateEvent(NULL, TRUE, TRUE, "");
      overlapped->Offset = 0;
      overlapped->OffsetHigh = 0;
   }
   if(!ReadFile(hidDevObject, inputReportBuffer, inputReportBufferLength,
                &numberOfBytesRead, overlapped)) {
      if(GetLastError() == ERROR_IO_PENDING) {
         result = WaitForSingleObject(overlapped->hEvent, INFINITE);
         if(result == WAIT_TIMEOUT) {
            CancelIo(hidDevObject);
            return false;
         }
         else
            if(result == WAIT_FAILED){
               cout << "Bd odczytu danych.";
               return false;
            }
            GetOverlappedResult(hidDevObject, overlapped,
                                &numberOfBytesRead, FALSE);
      }
      else
         displayError("Bd odczytu danych.");
   }
   ResetEvent(overlapped->hEvent);
   releaseMemory(overlapped);
   return true;
}
//---------------------------------------------------------
int main()
{
   HIDP_CAPS capabilities;
   PHIDP_PREPARSED_DATA preparsedData;
   HMODULE hLib = NULL;
   HANDLE  hidDeviceObject;
   BYTE *inputReportBuffer;

   long (__stdcall* HidP_GetCaps)(IN PHIDP_PREPARSED_DATA PreparsedData,
                                 OUT PHIDP_CAPS Capabilities);
   bool (__stdcall* HidD_GetPreparsedData)(IN HANDLE  HidDeviceObject,
                                 OUT PHIDP_PREPARSED_DATA *PreparsedData);
   bool (__stdcall* HidD_FreePreparsedData)(IN PHIDP_PREPARSED_DATA PreparsedData);

   TUSBDevice *usbDevice = new TUSBDevice();

   hLib = LoadLibrary("HID.DLL");
   if (!hLib)
     usbDevice->displayError("Bd doczenia biblioteki HID.DLL.");

   (FARPROC&) HidP_GetCaps=GetProcAddress(hLib,
                                             "HidP_GetCaps");
   (FARPROC&) HidD_GetPreparsedData=GetProcAddress(hLib,
                                             "HidD_GetPreparsedData");
   (FARPROC&) HidD_FreePreparsedData=GetProcAddress(hLib,
                                             "HidD_FreePreparsedData");

   if (!HidP_GetCaps || !HidD_GetPreparsedData || !HidD_FreePreparsedData){
      FreeLibrary(hLib);
      usbDevice->displayError("Nie znaleziono jednej lub wicej funkcji" \
                              " eksportowych.\n");
   }

// Synchroniczne operacje odczytu
   usbDevice->setUshortVid(8890);
   hidDeviceObject = usbDevice->synchOpenUSBDevice();
   if(HidD_GetPreparsedData(hidDeviceObject, &preparsedData)){
      HidP_GetCaps(preparsedData, &capabilities);
      inputReportBuffer = new BYTE[capabilities.InputReportByteLength];

      while(true) {
         usbDevice->synchReadUSBReport(hidDeviceObject, inputReportBuffer,
                                       capabilities.InputReportByteLength);
         printf("%d %d %d %d %d %d %d\n", inputReportBuffer[0],
                       inputReportBuffer[1], inputReportBuffer[2],
                       inputReportBuffer[3], inputReportBuffer[4],
                       inputReportBuffer[5], inputReportBuffer[6]);
        if(inputReportBuffer[6]==64 || \
           hidDeviceObject == INVALID_HANDLE_VALUE){
           HidD_FreePreparsedData(preparsedData);
           releaseMemory(inputReportBuffer);
           break;
        }
      }//koniec while
   }
   Win32Check(CloseHandle(hidDeviceObject));
   FreeLibrary(hLib);
   releaseMemory(usbDevice);
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------

